using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

namespace ResXBuilder
{
	/// <summary>
	/// Summary description for WinForm.
	/// </summary>
	public class RXBMainForm : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.MenuItem fileMenu;
		private System.Windows.Forms.MenuItem fileOpenMenu;
		private System.Windows.Forms.MenuItem windowCascadeMenu;
		private System.Windows.Forms.MenuItem windowTileMenu;
		private System.Windows.Forms.MenuItem windowArrangeIconsMenu;
		private System.Windows.Forms.MenuItem windowMinimizeAllMenu;
		private System.Windows.Forms.MenuItem windowCloseAllMenu;
		private System.Windows.Forms.MenuItem menuItem5;
		private System.Windows.Forms.MenuItem fileExitMenu;
		private System.Windows.Forms.MenuItem helpMenu;
		private System.Windows.Forms.MenuItem helpAboutMenu;
		private System.Windows.Forms.OpenFileDialog openFileDialog1;
		private System.Windows.Forms.MenuItem fileNewMenu;
		private System.Windows.Forms.MenuItem windowMenu;

		public RXBMainForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.fileMenu = new System.Windows.Forms.MenuItem();
			this.fileNewMenu = new System.Windows.Forms.MenuItem();
			this.fileOpenMenu = new System.Windows.Forms.MenuItem();
			this.menuItem5 = new System.Windows.Forms.MenuItem();
			this.fileExitMenu = new System.Windows.Forms.MenuItem();
			this.windowMenu = new System.Windows.Forms.MenuItem();
			this.windowCascadeMenu = new System.Windows.Forms.MenuItem();
			this.windowTileMenu = new System.Windows.Forms.MenuItem();
			this.windowArrangeIconsMenu = new System.Windows.Forms.MenuItem();
			this.windowMinimizeAllMenu = new System.Windows.Forms.MenuItem();
			this.windowCloseAllMenu = new System.Windows.Forms.MenuItem();
			this.helpMenu = new System.Windows.Forms.MenuItem();
			this.helpAboutMenu = new System.Windows.Forms.MenuItem();
			this.openFileDialog1 = new System.Windows.Forms.OpenFileDialog();
			// 
			// mainMenu1
			// 
			this.mainMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.fileMenu,
						this.windowMenu,
						this.helpMenu});
			// 
			// fileMenu
			// 
			this.fileMenu.Index = 0;
			this.fileMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.fileNewMenu,
						this.fileOpenMenu,
						this.menuItem5,
						this.fileExitMenu});
			this.fileMenu.MergeType = System.Windows.Forms.MenuMerge.MergeItems;
			this.fileMenu.Text = "&File";
			// 
			// fileNewMenu
			// 
			this.fileNewMenu.Index = 0;
			this.fileNewMenu.Shortcut = System.Windows.Forms.Shortcut.CtrlN;
			this.fileNewMenu.Text = "New";
			this.fileNewMenu.Click += new System.EventHandler(this.fileNewMenu_Click);
			// 
			// fileOpenMenu
			// 
			this.fileOpenMenu.Index = 1;
			this.fileOpenMenu.Shortcut = System.Windows.Forms.Shortcut.CtrlO;
			this.fileOpenMenu.Text = "&Open...";
			this.fileOpenMenu.Click += new System.EventHandler(this.fileOpenMenu_Click);
			// 
			// menuItem5
			// 
			this.menuItem5.Index = 2;
			this.menuItem5.MergeOrder = 2;
			this.menuItem5.Text = "-";
			// 
			// fileExitMenu
			// 
			this.fileExitMenu.Index = 3;
			this.fileExitMenu.MergeOrder = 2;
			this.fileExitMenu.Text = "E&xit";
			this.fileExitMenu.Click += new System.EventHandler(this.fileExitMenu_Click);
			// 
			// windowMenu
			// 
			this.windowMenu.Index = 1;
			this.windowMenu.MdiList = true;
			this.windowMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.windowCascadeMenu,
						this.windowTileMenu,
						this.windowArrangeIconsMenu,
						this.windowMinimizeAllMenu,
						this.windowCloseAllMenu});
			this.windowMenu.MergeOrder = 4;
			this.windowMenu.Text = "&Window";
			this.windowMenu.Select += new System.EventHandler(this.windowMenu_Select);
			// 
			// windowCascadeMenu
			// 
			this.windowCascadeMenu.Index = 0;
			this.windowCascadeMenu.Text = "&Cascade";
			this.windowCascadeMenu.Click += new System.EventHandler(this.windowCascadeMenu_Click);
			// 
			// windowTileMenu
			// 
			this.windowTileMenu.Index = 1;
			this.windowTileMenu.Text = "&Tile";
			this.windowTileMenu.Click += new System.EventHandler(this.windowTileMenu_Click);
			// 
			// windowArrangeIconsMenu
			// 
			this.windowArrangeIconsMenu.Index = 2;
			this.windowArrangeIconsMenu.Text = "&Arrange Icons";
			this.windowArrangeIconsMenu.Click += new System.EventHandler(this.windowArrangeIconsMenu_Click);
			// 
			// windowMinimizeAllMenu
			// 
			this.windowMinimizeAllMenu.Index = 3;
			this.windowMinimizeAllMenu.Text = "&Minimize All";
			this.windowMinimizeAllMenu.Click += new System.EventHandler(this.windowMinimizeAllMenu_Click);
			// 
			// windowCloseAllMenu
			// 
			this.windowCloseAllMenu.Index = 4;
			this.windowCloseAllMenu.Text = "C&lose All";
			this.windowCloseAllMenu.Click += new System.EventHandler(this.windowCloseAllMenu_Click);
			// 
			// helpMenu
			// 
			this.helpMenu.Index = 2;
			this.helpMenu.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.helpAboutMenu});
			this.helpMenu.MergeOrder = 4;
			this.helpMenu.Text = "&Help";
			// 
			// helpAboutMenu
			// 
			this.helpAboutMenu.Index = 0;
			this.helpAboutMenu.Text = "&About...";
			this.helpAboutMenu.Click += new System.EventHandler(this.helpAboutMenu_Click);
			// 
			// openFileDialog1
			// 
			this.openFileDialog1.DefaultExt = "resx";
			this.openFileDialog1.Filter = "ResX Files (*.resx)|*.resx|All Files (*.*)|*.*";
			// 
			// RXBMainForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.BackColor = System.Drawing.SystemColors.AppWorkspace;
			this.ClientSize = new System.Drawing.Size(472, 230);
			this.IsMdiContainer = true;
			this.Menu = this.mainMenu1;
			this.Name = "RXBMainForm";
			this.StartPosition = System.Windows.Forms.FormStartPosition.WindowsDefaultBounds;
			this.Text = "ResX Builder";
		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main()
		{
			Application.Run(new RXBMainForm());
		}

		private void fileOpenMenu_Click(object sender, System.EventArgs e)
		{
			openFileDialog1.FileName = "";
			if (openFileDialog1.ShowDialog() == DialogResult.OK)
			{
				RXBChildForm newForm = new RXBChildForm();
				newForm.MdiParent = this;
				newForm.openFile(openFileDialog1.FileName);
				newForm.Show();
			}
		}

		private void fileNewMenu_Click(object sender, System.EventArgs e)
		{
				RXBChildForm newForm = new RXBChildForm();
				newForm.MdiParent = this;
				newForm.Show();
		}

		private void helpAboutMenu_Click(object sender, System.EventArgs e)
		{
			MessageBox.Show("ResX Builder version 1.0\n\nCopyright  2003, Borland Software Corporation",
				"About ResX Builder", MessageBoxButtons.OK, MessageBoxIcon.Information);
		}

		private void fileExitMenu_Click(object sender, System.EventArgs e)
		{
			Close();
		}

		private void windowMenu_Select(object sender, System.EventArgs e)
		{
			windowCascadeMenu.Enabled = (ActiveMdiChild != null);
			windowTileMenu.Enabled = (ActiveMdiChild != null);
			windowArrangeIconsMenu.Enabled = (ActiveMdiChild != null);
			windowMinimizeAllMenu.Enabled = (ActiveMdiChild != null);
			windowCloseAllMenu.Enabled = (ActiveMdiChild != null);
		}
		
		private void windowCascadeMenu_Click(object sender, System.EventArgs e)
		{
			LayoutMdi(MdiLayout.Cascade);
		}
		
		private void windowTileMenu_Click(object sender, System.EventArgs e)
		{
			LayoutMdi(MdiLayout.TileHorizontal);
		}
		
		private void windowMinimizeAllMenu_Click(object sender, System.EventArgs e)
		{
			Form[] children = this.MdiChildren;
			for (int i = 0; i<children.Length; i++)
			{
				children[i].WindowState = FormWindowState.Minimized;
			}
		}

		private void windowArrangeIconsMenu_Click(object sender, System.EventArgs e)
		{
			LayoutMdi(MdiLayout.ArrangeIcons);
		}

		private void windowCloseAllMenu_Click(object sender, System.EventArgs e)
		{
			Form[] children = this.MdiChildren;
			for (int i = 0; i<children.Length; i++)
			{
				children[i].Close();
			}
		}
	}
}
